% ex7_51enkf.m  
% Ensemble Kalman Filter
% Van der Pol oscillator (Euler's method) 
% M=100 (number of particles)

clear;
x00=[0.2 0.1]';   % initial value
del=0.1;          %sampling interval
d2=sqrt(del);
T=50;             % period of simulation
N=T/del;          % number of sample points
x=zeros(3,N+1);
y=zeros(1,N+1);
R=0.01;          % covariance of observation noise
Q=[0.026  0      % covariance of system noise 
    0   0.01];   %
vd=sqrt(R)*randn(1,N+1);   %observation noise for data
wd=sqrt(Q)*randn(2,N+1);   %system noise for data
eps=1.0;          % unknown parameter
x(:,1)=[x00;eps];
C=[0 1 0];   % y= Cx
% data generation
for k=1:N
x(1,k+1)=x(1,k)+del*x(2,k)+d2*wd(1,k);
temp=eps*(1-x(1,k)^2)*x(2,k)-x(1,k);
x(2,k+1)=x(2,k)+del*temp+d2*wd(2,k);
x(3,k+1)=x(3,k);
y(1,k)=C*x(:,k)+vd(1,k);
end
y(1,N+1)=C*x(:,N+1)+vd(1,N+1);
%--------------Initializing of value-----------------------
n=3;      % dimension of EnKF
p=1;      % dimension of output
M=100;    % Number of particles
%M=50;
nu=zeros(p,M);
Ex=zeros(n,M);
Ey=zeros(p,M);
xtt0=sqrt(0.5)*randn(n,M);     % initial ensemble
xep=xtt0;
yep=zeros(p,M);   % ensemble for output prediction
xef=zeros(n,M);   % ensamble for filtered estimate
Re=R;             % covariance of observation noise
Q1=[0 0]; 
Qe=[Q Q1';        % covariance of system noise 
  Q1  0.00001];  % 10^{-5} for parameter estimation
%
%-------------------Estimation--------------------------------
for k=1:N+1
% observation update
% Input: (xep) --> Output (xef)
ve=sqrt(Re)*randn(p,M);  % observation noise for estimation 
for i=1:M
    yep(:,i)=C*xep(:,i)+ve(:,i);
end
xx=zeros(n,1);
yy=zeros(p,1);
for i=1:M
    xx=xx+xep(:,i);
    yy=yy+yep(:,i);
end
xx=xx/M;
yy=yy/M;
for i=1:M
Ex(:,i)=xep(:,i)-xx; % state prediction error
Ey(:,i)=yep(:,i)-yy; % ensemble for prediction error
end
Pxy=(Ex*Ey')/(M-1);
Pyy=(Ey*Ey')/(M-1);
Kt=Pxy*inv(Pyy);    % EnKF gain ( dimension n x p )
for i=1:M
    nu(:,i)=y(:,k)-yep(:,i);       % prediction output error
    xef(:,i)=xep(:,i)+Kt*nu(:,i);  % update of ensemble
end
xmean=mean(xef,2);
xhat(:,k)=xmean;      % filtered estimate
Kthat(:,:,k)=Kt;      %

% time update Input: (xef) --> Output (xep)
we=sqrt(Qe)*randn(n,M);  % system noise for estimation
for i=1:M
xep(1,i)=xef(1,i)+del*xef(2,i)+d2*we(1,i);
temp2=del*(xef(3,i)*(1-xef(1,i)^2)*xef(2,i)-xef(1,i));
xep(2,i)=xef(2,i)+temp2+d2*we(2,i);
xep(3,i)=xef(3,i)+d2*we(3,i);    
end
end  % of k
%--------------------------------------------------------------------------
% for figure
Et=zeros(1,N+1);
for k=1:N+1
Et(k)=sqrt((x(1,k)-xhat(1,k))^2+(x(2,k)-xhat(2,k))^2);
end

% output figure
J=0:N;
J=J*del;
figure(1)
plot(J,x(1,:),'r-',J,xhat(1,:),'b-','LineWidth',1.5)
xlabel('Time t (sec)')
title('Fig. 7.2a: Estimation of x_{1t} by EnKF')
axis([0 T -4 4])
grid
legend('True x_{1t}','Estimate by EnKF')  

figure(2)
plot(J,x(2,1:N+1),'r',J,xhat(2,1:N+1),'b-','LineWidth',1.5)
xlabel('Time t (sec)')
title('Fig. 7.2b: Estimation of x_{2t} by EnKF')
axis([0 T -4 4])
grid
legend('True x_{2t}','Estimate by EnKF')  

figure(3)
plot(J,Et,'b-','LineWidth',1.5)
axis([0 T 0 2])
grid
xlabel('Time t (sec)')
title('Fig. 7.4a: State estimation error by EnKF')
ylabel('E_t')
legend('State estimation error by EnKF')
hold on

figure(4)
plot(J,x(3,:),'r-',J,xhat(3,:),'b-','LineWidth',1.5)
xlabel('Time t (sec)')
ylabel('\epsilon_t')
axis([0 T -1 2])
grid
title('Fig. 7.4b: Parameter estimation by EnKF')
legend('True \epsilon=1','Estimate by EnKF')  
hold on



